/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Random;
import javax.swing.JOptionPane;

public class CopyOfMinesweeper
extends Frame
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1165525610327090406L;
    String version = "version 1.356";
    static URL imgURL = CopyOfMinesweeper.class.getResource("Mine.png");
    static Image mine_icon = Toolkit.getDefaultToolkit().getImage(imgURL);
    Font mineFont = new Font("Sans Serif", 1, 14);
    Panel topPanel = new Panel();
    Panel mainPanel = new Panel();
    static int rows;
    static int columns;
    int cbr;
    int cbc;
    int gridSize;
    static final double minePercentage = 0.1;
    int numberOfMines;
    int flags;
    int[] mineSpaces;
    int[][] buttonNumber;
    Space[][] minefield;
    boolean firstClick = true;

    public CopyOfMinesweeper() {
        int j;
        this.setupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new GridLayout(rows, columns));
        this.gridSize = rows * columns;
        this.buttonNumber = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                this.buttonNumber[i][j] = columns * j + i;
                ++j;
            }
            ++i;
        }
        this.minefield = new Space[rows][columns];
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                int p = i;
                int q = j;
                this.minefield[i][j] = new Space();
                this.mainPanel.add(this.minefield[i][j]);
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].setFont(this.mineFont);
                this.minefield[i][j].addActionListener(this);
                this.minefield[i][j].addMouseListener(this);
                this.minefield[i][j].setActionCommand(String.valueOf(this.buttonNumber[i][j]));
                ++j;
            }
            ++i;
        }
        this.setMines();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void setMines() {
        System.out.println(this.flags);
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.minefield[i][j].mine = false;
                this.minefield[i][j].tried = false;
                this.minefield[i][j].flagged = false;
                this.minefield[i][j].q_marked = false;
                ++j;
            }
            ++i;
        }
        this.numberOfMines = (int)Math.round(0.1 * (double)this.gridSize);
        Random mineGenerator = new Random();
        int[] mineSpaces = new int[this.numberOfMines];
        int i2 = 0;
        while (i2 < mineSpaces.length) {
            mineSpaces[i2] = mineGenerator.nextInt(this.gridSize);
            int r = mineSpaces[i2] / columns;
            int c = mineSpaces[i2] % columns;
            this.minefield[r][c].mine = true;
            System.out.println(mineSpaces[i2]);
            ++i2;
        }
        this.flags = this.numberOfMines;
        System.out.println(this.flags);
    }

    public static void main(String[] args) {
        rows = 15;
        columns = 15;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int fw = 22 * columns;
        int fh = 22 * rows + 20;
        int sw = dim.width;
        int sh = dim.height;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        CopyOfMinesweeper f = new CopyOfMinesweeper();
        f.setIconImage(mine_icon);
        f.setVisible(true);
        f.setTitle("Java Minesweeper!");
        f.setBounds(x, y, fw, fh);
        f.validate();
    }

    private void setupMenu() {
        MenuBar mnuBar = new MenuBar();
        this.setMenuBar(mnuBar);
        Menu FileMenu = new Menu("File", true);
        mnuBar.add(FileMenu);
        MenuItem NewItem = new MenuItem("New");
        FileMenu.add(NewItem);
        NewItem.addActionListener(this);
        MenuItem SaveItem = new MenuItem("Save");
        FileMenu.add(SaveItem);
        SaveItem.addActionListener(this);
        MenuItem ExitItem = new MenuItem("Exit");
        FileMenu.add(ExitItem);
        ExitItem.addActionListener(this);
        Menu HelpMenu = new Menu("Help", true);
        mnuBar.add(HelpMenu);
        MenuItem RulesItem = new MenuItem("Rules");
        HelpMenu.add(RulesItem);
        RulesItem.addActionListener(this);
        HelpMenu.insertSeparator(1);
        MenuItem AboutItem = new MenuItem("About");
        HelpMenu.add(AboutItem);
        AboutItem.addActionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mevt) {
        if (mevt.getButton() == 3 && !((Space)mevt.getComponent()).tried) {
            if (((Space)mevt.getComponent()).flagged) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("?");
                ((Space)mevt.getComponent()).flagged = false;
                ((Space)mevt.getComponent()).q_marked = true;
                ++this.flags;
            } else if (((Space)mevt.getComponent()).q_marked) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("");
                ((Space)mevt.getComponent()).flagged = false;
                ((Space)mevt.getComponent()).q_marked = false;
            } else {
                ((Button)mevt.getComponent()).setForeground(Color.RED);
                ((Button)mevt.getComponent()).setLabel("F");
                ((Space)mevt.getComponent()).flagged = true;
                ((Space)mevt.getComponent()).q_marked = false;
                --this.flags;
            }
            System.out.println(this.flags);
        }
        mevt.getButton();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("New" == ae.getActionCommand()) {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    this.minefield[i][j].setLabel("");
                    this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                    ++j;
                }
                ++i;
            }
            this.setMines();
            return;
        }
        if ("Save" == ae.getActionCommand()) {
            return;
        }
        if ("Exit" == ae.getActionCommand()) {
            System.exit(0);
        }
        if ("Rules" == ae.getActionCommand()) {
            String message = "RULES:\n- Click on the spaces to find all mines without hitting one.\n- The number on each space tells how many mines surround it.\n- Right click on spaces to flag them as a mine space.\nGood Luck!";
            JOptionPane.showMessageDialog(null, message, "Help - Rules", -1);
        }
        if ("About" == ae.getActionCommand()) {
            JOptionPane.showMessageDialog(null, "JAVA MINESWEEPER!\nCreated by Ryan McCann\n" + this.version, "About Java Minesweeper", -1);
        }
        if (!((Space)ae.getSource()).flagged) {
            boolean foundSpace = false;
            int i = 0;
            while (i < rows && !foundSpace) {
                int j = 0;
                while (j < columns && !foundSpace) {
                    if (String.valueOf(this.buttonNumber[i][j]).equals(ae.getActionCommand())) {
                        if (this.minefield[i][j].mine) {
                            this.minefield[i][j].setLabel("*");
                            this.minefield[i][j].tried = true;
                            this.failure();
                        } else {
                            this.cbr = i;
                            this.cbc = j;
                            this.notFailure();
                        }
                        int p = 0;
                        while (p < rows) {
                            int q = 0;
                            while (q < columns) {
                                ++q;
                            }
                            ++p;
                        }
                        foundSpace = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void success() {
        JOptionPane.showMessageDialog(null, "YOU WIN!");
    }

    public void failure() {
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.cbr = i;
                this.cbc = j++;
                this.notFailure();
            }
            ++i;
        }
        JOptionPane.showMessageDialog(null, "You Lose!", "FAILURE", 1);
    }

    public void notFailure() {
        this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(this.cbr, this.cbc);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines == 0) {
            this.minefield[this.cbr][this.cbc].setLabel("");
        }
        if (adjacentMines != 0) {
            this.minefield[this.cbr][this.cbc].setLabel("" + adjacentMines);
            if (adjacentMines == 1) {
                this.minefield[this.cbr][this.cbc].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[this.cbr][this.cbc].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[this.cbr][this.cbc].setForeground(red);
            }
        }
        if (this.minefield[this.cbr][this.cbc].mine) {
            this.minefield[this.cbr][this.cbc].setBackground(Color.GRAY);
            this.minefield[this.cbr][this.cbc].setForeground(Color.BLACK);
            this.minefield[this.cbr][this.cbc].setLabel("X");
        } else {
            this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
            this.uncoverSpaces(this.cbr, this.cbc);
        }
    }

    public void uncoverSpaces(int row, int col) {
        if (this.minefield[row][col].tried) {
            return;
        }
        if (this.minefield[row][col].flagged) {
            return;
        }
        this.minefield[row][col].tried = true;
        this.minefield[row][col].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(row, col);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines == 0) {
            this.minefield[row][col].setLabel("");
        }
        if (adjacentMines != 0) {
            this.minefield[row][col].setLabel("" + adjacentMines);
            if (adjacentMines == 1) {
                this.minefield[row][col].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[row][col].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[row][col].setForeground(red);
            }
            return;
        }
        if (this.minefield[row][col].mine) {
            this.minefield[row][col].setBackground(Color.BLACK);
            this.minefield[row][col].setForeground(Color.BLACK);
        } else if (adjacentMines == 0) {
            if (row == 0 && col == 0) {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (col == 0 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == 0 && col == columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
            } else if (col == 0 && row != 0 && row != rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (row == 0 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == rows - 1 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row - 1, col + 1);
            }
        } else {
            return;
        }
    }

    public int findAdjMines(int row, int col) {
        int adjacentMines = 0;
        boolean corner = false;
        if (row == 0 && col == 0) {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == 0 && row == rows - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (row == 0 && col == columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == columns - 1 && row == rows - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (!corner && col == 0) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (!corner && col == columns - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (row == 0 && col != 0 && col != columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else if (row == rows - 1 && col != 0 && col != columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
        }
        return adjacentMines;
    }
}

