/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Minesweeper
extends Frame
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1165525610327090406L;
    static final String version = "version 1.44";
    static String frameTitle = "Java Minesweeper!";
    static URL imgURL = Minesweeper.class.getResource("Mine.png");
    static Image mine_icon = Toolkit.getDefaultToolkit().getImage(imgURL);
    static ImageIcon img_icn = new ImageIcon(imgURL);
    URL explosionURL = this.getClass().getClassLoader().getResource("explosion.au");
    static Dimension dim;
    Font mineFont = new Font("Sans Serif", 1, 14);
    static Frame frame;
    Panel topPanel = new Panel();
    Panel mainPanel = new Panel();
    Color blue = new Color(0, 0, 255);
    Color green = new Color(0, 187, 0);
    Color red = new Color(255, 0, 0);
    Color darkBlue = new Color(0, 0, 128);
    Color darkGreen = new Color(0, 100, 0);
    Color darkRed = new Color(136, 0, 0);
    static int rows;
    static int columns;
    int cbr;
    int cbc;
    int gridSize;
    static final int SPACESIZE = 25;
    static double minePercentage;
    int numberOfMines;
    int flags;
    int[] mineSpaces;
    int[][] buttonNumber;
    private Space[][] minefield;
    boolean firstClick = true;
    Space spaceHit;

    static {
        minePercentage = 0.1;
    }

    public Minesweeper() {
        int j;
        this.setupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new GridLayout(rows, columns));
        this.gridSize = rows * columns;
        this.buttonNumber = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                this.buttonNumber[i][j] = columns * j + i;
                ++j;
            }
            ++i;
        }
        this.minefield = new Space[rows][columns];
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                this.minefield[i][j] = new Space();
                this.mainPanel.add(this.minefield[i][j]);
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].setFont(this.mineFont);
                this.minefield[i][j].addActionListener(this);
                this.minefield[i][j].addMouseListener(this);
                this.minefield[i][j].setActionCommand(String.valueOf(this.buttonNumber[i][j]));
                ++j;
            }
            ++i;
        }
        this.setMines();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void setMines() {
        this.resetSpaces();
        this.pickMines();
    }

    public void resetSpaces() {
        this.clearSpaces();
        Space[][] spaceArray = this.minefield;
        int n = this.minefield.length;
        int n2 = 0;
        while (n2 < n) {
            Space[] sp;
            Space[] spaceArray2 = sp = spaceArray[n2];
            int n3 = sp.length;
            int n4 = 0;
            while (n4 < n3) {
                Space s = spaceArray2[n4];
                s.mine = false;
                ++n4;
            }
            ++n2;
        }
    }

    public void clearSpaces() {
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.minefield[i][j].tried = false;
                this.minefield[i][j].flagged = false;
                this.minefield[i][j].q_marked = false;
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].setLabel("");
                this.flags = this.numberOfMines;
                ++j;
            }
            ++i;
        }
    }

    public void pickMines() {
        this.numberOfMines = (int)Math.round(minePercentage * (double)this.gridSize);
        Random mineGenerator = new Random();
        int[] mineSpaces = new int[this.numberOfMines];
        int i = 0;
        while (i < mineSpaces.length) {
            mineSpaces[i] = mineGenerator.nextInt(this.gridSize);
            do {
                if (!Minesweeper.isTaken(mineSpaces, mineSpaces[i], i)) continue;
                mineSpaces[i] = mineGenerator.nextInt(this.gridSize);
            } while (Minesweeper.isTaken(mineSpaces, mineSpaces[i], i));
            int r = mineSpaces[i] / columns;
            int c = mineSpaces[i] % columns;
            this.minefield[r][c].mine = true;
            ++i;
        }
        this.flags = this.numberOfMines;
    }

    private static boolean isTaken(int[] arr, int num, int index) {
        int i = 0;
        while (i < arr.length) {
            if (i != index && arr[i] == num) {
                return true;
            }
            System.out.println(String.valueOf(arr[i]));
            ++i;
        }
        return false;
    }

    public static void main(String[] args) {
        SplashScreen SS = new SplashScreen(0);
        SS.showSplash();
        rows = 15;
        columns = 15;
        dim = Toolkit.getDefaultToolkit().getScreenSize();
        Minesweeper f = new Minesweeper();
        int fw = 25 * columns;
        int fh = 25 * rows;
        int sw = Minesweeper.dim.width;
        int sh = Minesweeper.dim.height;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        f.setIconImage(mine_icon);
        f.setTitle(frameTitle);
        f.setVisible(true);
        f.setBounds(x, y, fw + f.getInsets().left + f.getInsets().right, fh + f.getInsets().top + f.getInsets().bottom);
        f.validate();
        frame = f;
        SS.destroySplash();
    }

    private void setupMenu() {
        MenuBar mnuBar = new MenuBar();
        this.setMenuBar(mnuBar);
        Menu FileMenu = new Menu("File", true);
        mnuBar.add(FileMenu);
        MenuItem NewItem = new MenuItem("New");
        FileMenu.add(NewItem);
        NewItem.addActionListener(this);
        MenuItem ResetItem = new MenuItem("Reset");
        FileMenu.add(ResetItem);
        ResetItem.addActionListener(this);
        FileMenu.insertSeparator(2);
        MenuItem OptionsItem = new MenuItem("Options");
        FileMenu.add(OptionsItem);
        ResetItem.addActionListener(this);
        FileMenu.insertSeparator(4);
        MenuItem SaveItem = new MenuItem("Save");
        FileMenu.add(SaveItem);
        SaveItem.addActionListener(this);
        MenuItem LoadItem = new MenuItem("Load");
        FileMenu.add(LoadItem);
        LoadItem.addActionListener(this);
        FileMenu.insertSeparator(7);
        MenuItem ExitItem = new MenuItem("Exit");
        FileMenu.add(ExitItem);
        ExitItem.addActionListener(this);
        Menu HelpMenu = new Menu("Help", true);
        mnuBar.add(HelpMenu);
        MenuItem RulesItem = new MenuItem("Rules");
        HelpMenu.add(RulesItem);
        RulesItem.addActionListener(this);
        MenuItem GamesItem = new MenuItem("More Games");
        HelpMenu.add(GamesItem);
        GamesItem.addActionListener(this);
        MenuItem AboutItem = new MenuItem("About");
        HelpMenu.add(AboutItem);
        AboutItem.addActionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mevt) {
        if (mevt.getButton() == 3 && !((Space)mevt.getComponent()).tried) {
            if (((Space)mevt.getComponent()).flagged) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("?");
                ((Space)mevt.getComponent()).flagged = false;
                ((Space)mevt.getComponent()).q_marked = true;
                ++this.flags;
            } else if (((Space)mevt.getComponent()).q_marked) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("");
                ((Space)mevt.getComponent()).flagged = false;
                ((Space)mevt.getComponent()).q_marked = false;
            } else {
                ((Button)mevt.getComponent()).setForeground(Color.RED);
                ((Button)mevt.getComponent()).setLabel("F");
                ((Space)mevt.getComponent()).flagged = true;
                ((Space)mevt.getComponent()).q_marked = false;
                --this.flags;
            }
            System.out.println("# mines/flags left: " + this.flags);
        }
        if (mevt.getButton() == 2) {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    if (mevt.getComponent() == this.minefield[i][j]) {
                        this.cbr = i;
                        this.cbc = j;
                        i = rows;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            boolean stop = false;
            if (this.minefield[this.cbr][this.cbc].tried) {
                System.out.println(String.valueOf(this.cbr) + "," + this.cbc);
                if (this.cbr != 0 && this.cbc != 0 && this.minefield[this.cbr - 1][this.cbc - 1].mine && !this.minefield[this.cbr - 1][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbr != 0 && this.minefield[this.cbr - 1][this.cbc].mine && !this.minefield[this.cbr - 1][this.cbc].flagged) {
                    stop = true;
                }
                if (this.cbr != 0 && this.cbc != columns - 1 && this.minefield[this.cbr - 1][this.cbc + 1].mine && !this.minefield[this.cbr - 1][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (this.cbc != 0 && this.minefield[this.cbr][this.cbc - 1].mine && !this.minefield[this.cbr][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbc != columns - 1 && this.minefield[this.cbr][this.cbc + 1].mine && !this.minefield[this.cbr][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (this.cbr != rows - 1 && this.cbc != 0 && this.minefield[this.cbr + 1][this.cbc - 1].mine && !this.minefield[this.cbr + 1][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbr != rows - 1 && this.minefield[this.cbr + 1][this.cbc].mine && !this.minefield[this.cbr + 1][this.cbc].flagged) {
                    stop = true;
                }
                if (this.cbr != rows - 1 && this.cbc != columns - 1 && this.minefield[this.cbr + 1][this.cbc + 1].mine && !this.minefield[this.cbr + 1][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (!stop) {
                    if (this.cbr == 0 && this.cbc == 0) {
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else if (this.cbc == 0 && this.cbr == rows - 1) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else if (this.cbr == 0 && this.cbc == columns - 1) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbc == columns - 1 && this.cbr == rows - 1) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                    } else if (this.cbc == 0 && this.cbr != 0 && this.cbr != rows - 1) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbc == columns - 1) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbr == 0 && this.cbc != 0 && this.cbc != columns - 1) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else if (this.cbr == rows - 1 && this.cbc != 0 && this.cbc != columns - 1) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else {
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("New" == ae.getActionCommand()) {
            this.setMines();
            return;
        }
        if ("Reset" == ae.getActionCommand()) {
            this.clearSpaces();
            return;
        }
        if ("Options" == ae.getActionCommand()) {
            return;
        }
        if ("Save" == ae.getActionCommand()) {
            try {
                this.save();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        if ("Load" == ae.getActionCommand()) {
            try {
                this.loadGame();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            return;
        }
        if ("Exit" == ae.getActionCommand()) {
            System.exit(0);
        } else {
            if ("Rules" == ae.getActionCommand()) {
                String message = "RULES:\n- Click on the spaces to find all mines without hitting one.\n- The number on each space tells how many mines surround it.\n- Right click on spaces to flag them as a mine space.\nGood Luck!";
                JOptionPane.showMessageDialog(this, message, "Help - Rules", -1);
                return;
            }
            if ("More Games" == ae.getActionCommand()) {
                try {
                    Runtime.getRuntime().exec("Explorer.exe C:/ProgramData/Microsoft/Windows/Start Menu/Programs/Games");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println(Runtime.getRuntime());
                System.out.println(System.getProperty("os.name"));
                System.out.println(System.getProperties());
                return;
            }
            if ("About" == ae.getActionCommand()) {
                JOptionPane.showMessageDialog(this, "JAVA MINESWEEPER!\nCreated by Ryan McCann\nversion 1.44", "About Java Minesweeper", -1);
                return;
            }
        }
        this.processClick(ae);
        this.checkSpacesLeft();
    }

    private void processClick(ActionEvent ae) {
        if (!((Space)ae.getSource()).flagged) {
            boolean foundSpace = false;
            int i = 0;
            while (i < rows && !foundSpace) {
                int j = 0;
                while (j < columns && !foundSpace) {
                    if (String.valueOf(this.buttonNumber[i][j]).equals(ae.getActionCommand())) {
                        if (this.minefield[i][j].mine) {
                            this.spaceHit = this.minefield[i][j];
                            this.minefield[i][j].tried = true;
                            try {
                                this.failure();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.cbr = i;
                            this.cbc = j;
                            this.notFailure();
                        }
                        int p = 0;
                        while (p < rows) {
                            int q = 0;
                            while (q < columns) {
                                ++q;
                            }
                            ++p;
                        }
                        foundSpace = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void checkSpacesLeft() {
        int temp_counter = 0;
        int num_correctly_flagged = 0;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                if (this.minefield[i][j].tried) {
                    ++temp_counter;
                }
                if (this.minefield[i][j].mine && this.minefield[i][j].flagged) {
                    num_correctly_flagged = (short)(num_correctly_flagged + 1);
                    System.out.println("# correctly flagged: " + num_correctly_flagged);
                }
                ++j;
            }
            ++i;
        }
        if (num_correctly_flagged == this.numberOfMines) {
            this.success();
        }
        System.out.println("# of tried spaces: " + temp_counter);
    }

    private void save() throws FileNotFoundException, IOException {
        frame.setTitle(String.valueOf(frameTitle) + " Saving...");
        long time = System.currentTimeMillis();
        File gameSave = new File("gameSave");
        ObjectOutputStream output_stream = new ObjectOutputStream(new FileOutputStream(gameSave));
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                output_stream.writeObject(this.minefield[i][j]);
                ++j;
            }
            ++i;
        }
        output_stream.flush();
        output_stream.close();
        frame.setTitle(frameTitle);
        System.out.println("Save time: " + (System.currentTimeMillis() - time) + " ms");
    }

    private void loadGame() throws FileNotFoundException, IOException, ClassNotFoundException {
        frame.setTitle(String.valueOf(frameTitle) + " Loading...");
        long time = System.currentTimeMillis();
        ObjectInputStream input_stream = new ObjectInputStream(new FileInputStream(new File("gameSave")));
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                Space temp = (Space)input_stream.readObject();
                this.minefield[i][j].mine = temp.mine;
                this.minefield[i][j].tried = temp.tried;
                this.minefield[i][j].flagged = temp.flagged;
                this.minefield[i][j].q_marked = temp.q_marked;
                this.minefield[i][j].setBackground(temp.getBackground());
                this.minefield[i][j].setForeground(temp.getForeground());
                this.minefield[i][j].setLabel(temp.getLabel());
                ++j;
            }
            ++i;
        }
        input_stream.close();
        frame.setTitle(frameTitle);
        System.out.println("Load time: " + (System.currentTimeMillis() - time) + " ms");
    }

    private Color getColor(int numberAdjacent) {
        if (numberAdjacent == 1) {
            return this.blue;
        }
        if (numberAdjacent == 2) {
            return this.green;
        }
        if (numberAdjacent == 3) {
            return this.red;
        }
        if (numberAdjacent == 4) {
            return this.darkBlue;
        }
        if (numberAdjacent == 5) {
            return this.darkGreen;
        }
        if (numberAdjacent >= 6) {
            return this.darkRed;
        }
        return Color.BLACK;
    }

    public void success() {
        JOptionPane.showMessageDialog(this, "YOU WIN!", "Success", 1);
    }

    public void failure() throws IOException {
        try {
            Audio explosion = new Audio(this.explosionURL);
            explosion.play();
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.cbr = i;
                this.cbc = j++;
                this.revealSpaces();
            }
            ++i;
        }
    }

    public void notFailure() {
        int adjacentMines = this.findAdjMines(this.cbr, this.cbc);
        if (adjacentMines == 0) {
            // empty if block
        }
        boolean cfr_ignored_0 = this.minefield[this.cbr][this.cbc].mine;
        this.uncoverSpaces(this.cbr, this.cbc);
    }

    public void revealSpaces() {
        int adjacentMines = this.findAdjMines(this.cbr, this.cbc);
        if (this.minefield[this.cbr][this.cbc].mine) {
            if (!this.minefield[this.cbr][this.cbc].flagged) {
                this.minefield[this.cbr][this.cbc].setBackground(Color.GRAY);
                this.minefield[this.cbr][this.cbc].setForeground(Color.BLACK);
                this.minefield[this.cbr][this.cbc].setLabel("X");
                if (this.minefield[this.cbr][this.cbc] == this.spaceHit) {
                    this.minefield[this.cbr][this.cbc].setBackground(Color.BLACK);
                }
            }
            return;
        }
        if (adjacentMines != 0) {
            this.minefield[this.cbr][this.cbc].setLabel("" + adjacentMines);
            this.minefield[this.cbr][this.cbc].setForeground(this.getColor(adjacentMines));
            this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
        } else {
            this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
        }
    }

    public void uncoverSpaces(int row, int col) {
        if (this.minefield[row][col].tried) {
            return;
        }
        if (this.minefield[row][col].flagged) {
            return;
        }
        this.minefield[row][col].tried = true;
        this.minefield[row][col].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(row, col);
        if (adjacentMines != 0) {
            this.minefield[row][col].setForeground(this.getColor(adjacentMines));
            this.minefield[row][col].setLabel("" + adjacentMines);
            return;
        }
        if (adjacentMines == 0) {
            this.minefield[row][col].setLabel("");
            if (row == 0 && col == 0) {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (col == 0 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == 0 && col == columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
            } else if (col == 0 && row != 0 && row != rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (row == 0 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == rows - 1 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row - 1, col + 1);
            }
        } else {
            return;
        }
    }

    public int findAdjMines(int row, int col) {
        int adjacentMines = 0;
        boolean corner = false;
        if (row == 0 && col == 0) {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == 0 && row == rows - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (row == 0 && col == columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == columns - 1 && row == rows - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (!corner && col == 0) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (!corner && col == columns - 1) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (row == 0 && col != 0 && col != columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else if (row == rows - 1 && col != 0 && col != columns - 1) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
        }
        return adjacentMines;
    }
}

