/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MinesweeperSwing
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Font mineFont = new Font("Sans Serif", 1, 14);
    JPanel topPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    static int rows;
    static int columns;
    int cbr;
    int cbc;
    int gridSize;
    double minePercentage = 0.1;
    int numberOfMines;
    int[] mineSpaces;
    int[][] buttonNumber;
    JButton[][] minefield;
    boolean[][] mine;
    boolean[][] tried;
    boolean[][] rightClicked;
    boolean firstClick = true;

    public MinesweeperSwing() {
        int j;
        this.setupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new GridLayout(rows, columns));
        this.gridSize = rows * columns;
        this.buttonNumber = new int[rows][columns];
        int i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                this.buttonNumber[i][j] = columns * j + i;
                ++j;
            }
            ++i;
        }
        this.minefield = new JButton[rows][columns];
        this.rightClicked = new boolean[rows][columns];
        i = 0;
        while (i < rows) {
            j = 0;
            while (j < columns) {
                final int p = i;
                final int q = j;
                this.rightClicked[i][j] = false;
                this.minefield[i][j] = new JButton("");
                this.mainPanel.add(this.minefield[i][j]);
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].addActionListener(this);
                this.minefield[i][j].addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent me) {
                        if (me.getButton() == 3) {
                            MinesweeperSwing.this.rightClicked[p][q] = true;
                        }
                    }
                });
                this.minefield[i][j].setActionCommand(String.valueOf(this.buttonNumber[i][j]));
                ++j;
            }
            ++i;
        }
        this.setMines();
    }

    public void setMines() {
        this.mine = new boolean[rows][columns];
        this.tried = new boolean[rows][columns];
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < columns) {
                this.mine[i][j] = false;
                this.tried[i][j] = false;
                ++j;
            }
            ++i;
        }
        this.numberOfMines = (int)Math.round(this.minePercentage * (double)this.gridSize);
        Random mineGenerator = new Random();
        int[] mineSpaces = new int[this.numberOfMines];
        int i2 = 0;
        while (i2 < mineSpaces.length) {
            mineSpaces[i2] = mineGenerator.nextInt(this.gridSize);
            int r = mineSpaces[i2] / columns;
            int c = mineSpaces[i2] % columns;
            this.mine[r][c] = true;
            ++i2;
        }
    }

    private void setupMenu() {
        JMenuBar mnuBar = new JMenuBar();
        this.setJMenuBar(mnuBar);
        JMenu FileMenu = new JMenu("File", true);
        mnuBar.add(FileMenu);
        JMenuItem NewItem = new JMenuItem("New");
        FileMenu.add(NewItem);
        NewItem.addActionListener(this);
        JMenuItem SaveItem = new JMenuItem("Save");
        FileMenu.add(SaveItem);
        SaveItem.addActionListener(this);
        JMenuItem ExitItem = new JMenuItem("Exit");
        FileMenu.add(ExitItem);
        ExitItem.addActionListener(this);
        JMenu HelpMenu = new JMenu("Help", true);
        mnuBar.add(HelpMenu);
        JMenuItem RulesItem = new JMenuItem("Rules");
        HelpMenu.add(RulesItem);
        RulesItem.addActionListener(this);
        HelpMenu.insertSeparator(1);
        JMenuItem AboutItem = new JMenuItem("About");
        HelpMenu.add(AboutItem);
        AboutItem.addActionListener(this);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        rows = 15;
        columns = 15;
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int fw = 22 * columns;
        int fh = 22 * rows + 19;
        int sw = dim.width;
        int sh = dim.height;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        MinesweeperSwing f = new MinesweeperSwing();
        f.setVisible(true);
        f.setTitle("Java MinesweeperSwing!");
        f.setBounds(x, y, fw, fh);
        f.validate();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("New" == ae.getActionCommand()) {
            int i = 0;
            while (i < rows) {
                int j = 0;
                while (j < columns) {
                    this.minefield[i][j].setLabel("");
                    this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                    ++j;
                }
                ++i;
            }
            this.setMines();
        }
        if ("Exit" == ae.getActionCommand()) {
            System.exit(0);
        }
        if ("Rules" == ae.getActionCommand()) {
            String message = "RULES:\n- Click on the spaces to find all mines without hitting one.\n- The number on each space tells how many mines surround it.\nGood Luck!";
            JOptionPane.showMessageDialog(null, message, "Help - Rules", -1);
        }
        if ("About" == ae.getActionCommand()) {
            JOptionPane.showMessageDialog(null, "JAVA MinesweeperSwing!\nCreated by Ryan McCann", "About Java MinesweeperSwing", -1);
        }
        boolean foundSpace = false;
        int i = 0;
        while (i < rows && !foundSpace) {
            int j = 0;
            while (j < columns && !foundSpace) {
                if (String.valueOf(this.buttonNumber[i][j]).equals(ae.getActionCommand())) {
                    this.minefield[i][j].addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent me) {
                            if (me.getClickCount() == 3) {
                                JOptionPane.showMessageDialog(null, "triple Click");
                            } else if (me.getClickCount() == 2) {
                                JOptionPane.showMessageDialog(null, "Double Click");
                            }
                        }
                    });
                    if (this.rightClicked[i][j]) {
                        this.minefield[i][j].setBackground(Color.RED);
                    }
                    if (this.mine[i][j]) {
                        this.minefield[i][j].setBackground(Color.BLACK);
                        this.failure();
                    } else if (!this.rightClicked[i][j]) {
                        this.cbr = i;
                        this.cbc = j;
                        this.notFailure();
                    }
                    int p = 0;
                    while (p < rows) {
                        int q = 0;
                        while (q < columns) {
                            ++q;
                        }
                        ++p;
                    }
                    foundSpace = true;
                }
                ++j;
            }
            ++i;
        }
    }

    public void failure() {
    }

    public void notFailure() {
        this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(this.cbr, this.cbc);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines != 0) {
            this.minefield[this.cbr][this.cbc].setLabel("" + adjacentMines);
            this.minefield[this.cbr][this.cbc].setFont(this.mineFont);
            if (adjacentMines == 1) {
                this.minefield[this.cbr][this.cbc].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[this.cbr][this.cbc].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[this.cbr][this.cbc].setForeground(red);
            }
        }
        if (this.mine[this.cbr][this.cbc]) {
            this.minefield[this.cbr][this.cbc].setBackground(Color.BLACK);
            this.minefield[this.cbr][this.cbc].setForeground(Color.BLACK);
        } else {
            this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
            this.uncoverSpaces(this.cbr, this.cbc);
        }
    }

    public void uncoverSpaces(int row, int col) {
        if (this.tried[row][col]) {
            return;
        }
        this.tried[row][col] = true;
        this.minefield[row][col].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(row, col);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines != 0) {
            this.minefield[row][col].setLabel("" + adjacentMines);
            this.minefield[row][col].setFont(this.mineFont);
            if (adjacentMines == 1) {
                this.minefield[row][col].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[row][col].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[row][col].setForeground(red);
            }
            return;
        }
        if (this.mine[row][col]) {
            this.minefield[row][col].setBackground(Color.BLACK);
            this.minefield[row][col].setForeground(Color.BLACK);
        } else if (adjacentMines == 0) {
            if (row == 0 && col == 0) {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (col == 0 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == 0 && col == columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1 && row == rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
            } else if (col == 0 && row != 0 && row != rows - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == columns - 1) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (row == 0 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == rows - 1 && col != 0 && col != columns - 1) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row - 1, col + 1);
            }
        } else {
            return;
        }
    }

    public int findAdjMines(int row, int col) {
        int adjacentMines = 0;
        boolean corner = false;
        if (row == 0 && col == 0) {
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == 0 && row == rows - 1) {
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
            corner = true;
        } else if (row == 0 && col == columns - 1) {
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == columns - 1 && row == rows - 1) {
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            corner = true;
        } else if (!corner && col == 0) {
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
        } else if (!corner && col == columns - 1) {
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
        } else if (row == 0 && col != 0 && col != columns - 1) {
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
        } else if (row == rows - 1 && col != 0 && col != columns - 1) {
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
        } else {
            if (this.mine[row + 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col]) {
                ++adjacentMines;
            }
            if (this.mine[row][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col + 1]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row + 1][col - 1]) {
                ++adjacentMines;
            }
            if (this.mine[row - 1][col + 1]) {
                ++adjacentMines;
            }
        }
        return adjacentMines;
    }
}

