/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class Minesweeper_Applet
extends Applet
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1165525610327090406L;
    static String version = "version 1.4";
    static String frameTitle = "Java Minesweeper!";
    static URL imgURL = Minesweeper_Applet.class.getResource("Mine.png");
    static Image mine_icon = Toolkit.getDefaultToolkit().getImage(imgURL);
    static ImageIcon img_icn = new ImageIcon(imgURL);
    static URL explosionURL = Minesweeper_Applet.class.getResource("explosion.au");
    static Dimension dim;
    Font mineFont = new Font("Sans Serif", 1, 14);
    static Minesweeper_Applet frame;
    Panel topPanel = new Panel();
    Panel mainPanel = new Panel();
    static int rows;
    int cbr;
    int cbc;
    int gridSize;
    static final double minePercentage = 0.1;
    int numberOfMines;
    int flags;
    int[] mineSpaces;
    int[][] buttonNumber;
    private AppletSpace[][] minefield;
    boolean firstClick = true;

    @Override
    public void init() {
        dim = Toolkit.getDefaultToolkit().getScreenSize();
        int fw = 330;
        int fh = 22 * rows + 20;
        int sw = Minesweeper_Applet.dim.width;
        int sh = Minesweeper_Applet.dim.height;
        int x = (sw - fw) / 2;
        int y = (sh - fh) / 2;
        Minesweeper_Applet f = new Minesweeper_Applet();
        f.setVisible(true);
        f.setBounds(x, y, fw, fh);
        f.validate();
        frame = f;
    }

    public Minesweeper_Applet() {
        int j;
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(new GridLayout(15, 15));
        this.gridSize = 225;
        this.buttonNumber = new int[15][15];
        int i = 0;
        while (i < 15) {
            j = 0;
            while (j < 15) {
                this.buttonNumber[i][j] = 15 * j + i;
                ++j;
            }
            ++i;
        }
        this.minefield = new AppletSpace[15][15];
        i = 0;
        while (i < 15) {
            j = 0;
            while (j < 15) {
                this.minefield[i][j] = new AppletSpace();
                this.mainPanel.add(this.minefield[i][j]);
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].setFont(this.mineFont);
                this.minefield[i][j].addActionListener(this);
                this.minefield[i][j].addMouseListener(this);
                this.minefield[i][j].setActionCommand(String.valueOf(this.buttonNumber[i][j]));
                ++j;
            }
            ++i;
        }
        this.setMines();
    }

    public void setMines() {
        System.out.println(this.flags);
        this.resetSpaces();
        this.pickMines();
        System.out.println(this.flags);
    }

    public void resetSpaces() {
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < 15) {
                this.minefield[i][j].mine = false;
                this.minefield[i][j].tried = false;
                this.minefield[i][j].flagged = false;
                this.minefield[i][j].q_marked = false;
                this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                this.minefield[i][j].setLabel("");
                ++j;
            }
            ++i;
        }
    }

    public void pickMines() {
        this.numberOfMines = (int)Math.round(0.1 * (double)this.gridSize);
        Random mineGenerator = new Random();
        int[] mineSpaces = new int[this.numberOfMines];
        int i = 0;
        while (i < mineSpaces.length) {
            mineSpaces[i] = mineGenerator.nextInt(this.gridSize);
            do {
                if (!Minesweeper_Applet.isTaken(mineSpaces, mineSpaces[i], i)) continue;
                mineSpaces[i] = mineGenerator.nextInt(this.gridSize);
            } while (Minesweeper_Applet.isTaken(mineSpaces, mineSpaces[i], i));
            int r = mineSpaces[i] / 15;
            int c = mineSpaces[i] % 15;
            this.minefield[r][c].mine = true;
            ++i;
        }
        this.flags = this.numberOfMines;
    }

    private static boolean isTaken(int[] arr, int num, int index) {
        int i = 0;
        while (i < arr.length) {
            if (i != index && arr[i] == num) {
                return true;
            }
            System.out.println(String.valueOf(arr[i]));
            ++i;
        }
        return false;
    }

    private void setupMenu() {
        MenuBar mnuBar = new MenuBar();
        Menu FileMenu = new Menu("File", true);
        mnuBar.add(FileMenu);
        MenuItem NewItem = new MenuItem("New");
        FileMenu.add(NewItem);
        NewItem.addActionListener(this);
        MenuItem ResetItem = new MenuItem("Reset");
        FileMenu.add(ResetItem);
        ResetItem.addActionListener(this);
        FileMenu.insertSeparator(2);
        MenuItem OptionsItem = new MenuItem("Options");
        FileMenu.add(OptionsItem);
        ResetItem.addActionListener(this);
        FileMenu.insertSeparator(4);
        MenuItem SaveItem = new MenuItem("Save");
        FileMenu.add(SaveItem);
        SaveItem.addActionListener(this);
        MenuItem LoadItem = new MenuItem("Load");
        FileMenu.add(LoadItem);
        LoadItem.addActionListener(this);
        FileMenu.insertSeparator(7);
        MenuItem ExitItem = new MenuItem("Exit");
        FileMenu.add(ExitItem);
        ExitItem.addActionListener(this);
        Menu HelpMenu = new Menu("Help", true);
        mnuBar.add(HelpMenu);
        MenuItem RulesItem = new MenuItem("Rules");
        HelpMenu.add(RulesItem);
        RulesItem.addActionListener(this);
        MenuItem GamesItem = new MenuItem("More Games");
        HelpMenu.add(GamesItem);
        GamesItem.addActionListener(this);
        MenuItem AboutItem = new MenuItem("About");
        HelpMenu.add(AboutItem);
        AboutItem.addActionListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mevt) {
        if (mevt.getButton() == 3 && !((AppletSpace)mevt.getComponent()).tried) {
            if (((AppletSpace)mevt.getComponent()).flagged) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("?");
                ((AppletSpace)mevt.getComponent()).flagged = false;
                ((AppletSpace)mevt.getComponent()).q_marked = true;
                ++this.flags;
            } else if (((AppletSpace)mevt.getComponent()).q_marked) {
                ((Button)mevt.getComponent()).setForeground(Color.BLACK);
                ((Button)mevt.getComponent()).setLabel("");
                ((AppletSpace)mevt.getComponent()).flagged = false;
                ((AppletSpace)mevt.getComponent()).q_marked = false;
            } else {
                ((Button)mevt.getComponent()).setForeground(Color.RED);
                ((Button)mevt.getComponent()).setLabel("F");
                ((AppletSpace)mevt.getComponent()).flagged = true;
                ((AppletSpace)mevt.getComponent()).q_marked = false;
                --this.flags;
            }
            System.out.println("# mines/flags left: " + this.flags);
        }
        if (mevt.getButton() == 2) {
            int i = 0;
            while (i < 15) {
                int j = 0;
                while (j < 15) {
                    if (mevt.getComponent() == this.minefield[i][j]) {
                        this.cbr = i;
                        this.cbc = j;
                        i = 15;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            boolean stop = false;
            if (this.minefield[this.cbr][this.cbc].tried) {
                System.out.println(String.valueOf(this.cbr) + "," + this.cbc);
                if (this.cbr != 0 && this.cbc != 0 && this.minefield[this.cbr - 1][this.cbc - 1].mine && !this.minefield[this.cbr - 1][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbr != 0 && this.minefield[this.cbr - 1][this.cbc].mine && !this.minefield[this.cbr - 1][this.cbc].flagged) {
                    stop = true;
                }
                if (this.cbr != 0 && this.cbc != 14 && this.minefield[this.cbr - 1][this.cbc + 1].mine && !this.minefield[this.cbr - 1][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (this.cbc != 0 && this.minefield[this.cbr][this.cbc - 1].mine && !this.minefield[this.cbr][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbc != 14 && this.minefield[this.cbr][this.cbc + 1].mine && !this.minefield[this.cbr][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (this.cbr != 14 && this.cbc != 0 && this.minefield[this.cbr + 1][this.cbc - 1].mine && !this.minefield[this.cbr + 1][this.cbc - 1].flagged) {
                    stop = true;
                }
                if (this.cbr != 14 && this.minefield[this.cbr + 1][this.cbc].mine && !this.minefield[this.cbr + 1][this.cbc].flagged) {
                    stop = true;
                }
                if (this.cbr != 14 && this.cbc != 14 && this.minefield[this.cbr + 1][this.cbc + 1].mine && !this.minefield[this.cbr + 1][this.cbc + 1].flagged) {
                    stop = true;
                }
                if (!stop) {
                    if (this.cbr == 0 && this.cbc == 0) {
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                        System.out.println("lskjdklj");
                    } else if (this.cbc == 0 && this.cbr == 14) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else if (this.cbr == 0 && this.cbc == 14) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbc == 14 && this.cbr == 14) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                    } else if (this.cbc == 0 && this.cbr != 0 && this.cbr != 14) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbc == 14) {
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                    } else if (this.cbr == 0 && this.cbc != 0 && this.cbc != 14) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else if (this.cbr == 14 && this.cbc != 0 && this.cbc != 14) {
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                    } else {
                        if (!this.minefield[this.cbr - 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr - 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr - 1, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr, this.cbc + 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc - 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc - 1);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc);
                        }
                        if (!this.minefield[this.cbr + 1][this.cbc + 1].mine) {
                            this.uncoverSpaces(this.cbr + 1, this.cbc + 1);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if ("New" == ae.getActionCommand()) {
            int i = 0;
            while (i < 15) {
                int j = 0;
                while (j < 15) {
                    this.minefield[i][j].setLabel("");
                    this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                    ++j;
                }
                ++i;
            }
            this.setMines();
            return;
        }
        if ("Reset" == ae.getActionCommand()) {
            int i = 0;
            while (i < 15) {
                int j = 0;
                while (j < 15) {
                    this.minefield[i][j].tried = false;
                    this.minefield[i][j].flagged = false;
                    this.minefield[i][j].q_marked = false;
                    this.minefield[i][j].setBackground(Color.LIGHT_GRAY);
                    this.minefield[i][j].setLabel("");
                    this.minefield[i][j].tried = false;
                    this.flags = this.numberOfMines;
                    ++j;
                }
                ++i;
            }
            return;
        }
        if ("Options" == ae.getActionCommand()) {
            return;
        }
        if ("Save" == ae.getActionCommand()) {
            return;
        }
        if ("Load" == ae.getActionCommand()) {
            return;
        }
        if ("Exit" == ae.getActionCommand()) {
            System.exit(0);
        } else {
            if ("Rules" == ae.getActionCommand()) {
                String message = "RULES:\n- Click on the spaces to find all mines without hitting one.\n- The number on each space tells how many mines surround it.\n- Right click on spaces to flag them as a mine space.\nGood Luck!";
                JOptionPane.showMessageDialog(null, message, "Help - Rules", -1);
                return;
            }
            if ("More Games" == ae.getActionCommand()) {
                try {
                    Runtime.getRuntime().exec("Explorer.exe C:/ProgramData/Microsoft/Windows/Start Menu/Programs/Games");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println(Runtime.getRuntime());
                System.out.println(System.getProperty("os.name"));
                System.out.println(System.getProperties());
                return;
            }
            if ("About" == ae.getActionCommand()) {
                JOptionPane.showMessageDialog(null, "JAVA MINESWEEPER!\nCreated by Ryan McCann\n" + version, "About Java Minesweeper", -1);
                return;
            }
        }
        if (!((AppletSpace)ae.getSource()).flagged) {
            boolean foundSpace = false;
            int i = 0;
            while (i < 15 && !foundSpace) {
                int j = 0;
                while (j < 15 && !foundSpace) {
                    if (String.valueOf(this.buttonNumber[i][j]).equals(ae.getActionCommand())) {
                        if (this.minefield[i][j].mine) {
                            this.minefield[i][j].setLabel("*");
                            this.minefield[i][j].tried = true;
                            try {
                                this.failure();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.cbr = i;
                            this.cbc = j;
                            this.notFailure();
                        }
                        int p = 0;
                        while (p < 15) {
                            int q = 0;
                            while (q < 15) {
                                ++q;
                            }
                            ++p;
                        }
                        foundSpace = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        int temp_counter = 0;
        int num_correctly_flagged = 0;
        int i = 0;
        while (i < 15) {
            int j = 0;
            while (j < 15) {
                if (this.minefield[i][j].tried) {
                    ++temp_counter;
                }
                if (this.minefield[i][j].mine && this.minefield[i][j].flagged) {
                    num_correctly_flagged = (short)(num_correctly_flagged + 1);
                    System.out.println("# correctly flagged: " + num_correctly_flagged);
                }
                ++j;
            }
            ++i;
        }
        if (num_correctly_flagged == this.numberOfMines) {
            this.success();
        }
        System.out.println("# of tried spaces: " + temp_counter);
    }

    public void success() {
        JOptionPane.showMessageDialog(null, "YOU WIN!", "Success", 1);
    }

    public void failure() throws IOException {
        AudioClip audio = this.getAudioClip(this.getCodeBase(), "explosion.au");
        audio.play();
        int i = 0;
        while (i < 15) {
            int j = 0;
            while (j < 15) {
                this.cbr = i;
                this.cbc = j++;
                this.notFailure();
            }
            ++i;
        }
        JOptionPane.showMessageDialog(null, "You Lose!", "FAILURE", 1);
    }

    public void notFailure() {
        this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(this.cbr, this.cbc);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines == 0) {
            this.minefield[this.cbr][this.cbc].setLabel("");
        }
        if (adjacentMines != 0) {
            this.minefield[this.cbr][this.cbc].setLabel("" + adjacentMines);
            if (adjacentMines == 1) {
                this.minefield[this.cbr][this.cbc].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[this.cbr][this.cbc].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[this.cbr][this.cbc].setForeground(red);
            }
        }
        if (this.minefield[this.cbr][this.cbc].mine) {
            this.minefield[this.cbr][this.cbc].setBackground(Color.GRAY);
            this.minefield[this.cbr][this.cbc].setForeground(Color.BLACK);
            this.minefield[this.cbr][this.cbc].setLabel("X");
        } else {
            this.minefield[this.cbr][this.cbc].setBackground(Color.WHITE);
            this.uncoverSpaces(this.cbr, this.cbc);
        }
    }

    public void uncoverSpaces(int row, int col) {
        if (this.minefield[row][col].tried) {
            return;
        }
        if (this.minefield[row][col].flagged) {
            return;
        }
        this.minefield[row][col].tried = true;
        this.minefield[row][col].setBackground(Color.WHITE);
        int adjacentMines = this.findAdjMines(row, col);
        Color blue = new Color(0, 0, 255);
        Color green = new Color(0, 204, 0);
        Color red = new Color(255, 0, 0);
        if (adjacentMines == 0) {
            this.minefield[row][col].setLabel("");
        }
        if (adjacentMines != 0) {
            this.minefield[row][col].setLabel("" + adjacentMines);
            if (adjacentMines == 1) {
                this.minefield[row][col].setForeground(blue);
            }
            if (adjacentMines == 2) {
                this.minefield[row][col].setForeground(green);
            }
            if (adjacentMines == 3) {
                this.minefield[row][col].setForeground(red);
            }
            return;
        }
        if (this.minefield[row][col].mine) {
            this.minefield[row][col].setBackground(Color.BLACK);
            this.minefield[row][col].setForeground(Color.BLACK);
        } else if (adjacentMines == 0) {
            this.minefield[row][col].setLabel("");
            if (row == 0 && col == 0) {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (col == 0 && row == 14) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == 0 && col == 14) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == 14 && row == 14) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
            } else if (col == 0 && row != 0 && row != 14) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row + 1, col);
            } else if (col == 14) {
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
            } else if (row == 0 && col != 0 && col != 14) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else if (row == 14 && col != 0 && col != 14) {
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row - 1, col + 1);
                this.uncoverSpaces(row, col + 1);
            } else {
                this.uncoverSpaces(row + 1, col);
                this.uncoverSpaces(row - 1, col);
                this.uncoverSpaces(row, col + 1);
                this.uncoverSpaces(row, col - 1);
                this.uncoverSpaces(row + 1, col + 1);
                this.uncoverSpaces(row - 1, col - 1);
                this.uncoverSpaces(row + 1, col - 1);
                this.uncoverSpaces(row - 1, col + 1);
            }
        } else {
            return;
        }
    }

    public int findAdjMines(int row, int col) {
        int adjacentMines = 0;
        boolean corner = false;
        if (row == 0 && col == 0) {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == 0 && row == 14) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (row == 0 && col == 14) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (col == 14 && row == 14) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            corner = true;
        } else if (!corner && col == 0) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (!corner && col == 14) {
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
        } else if (row == 0 && col != 0 && col != 14) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else if (row == 14 && col != 0 && col != 14) {
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
        } else {
            if (this.minefield[row + 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col + 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row + 1][col - 1].mine) {
                ++adjacentMines;
            }
            if (this.minefield[row - 1][col + 1].mine) {
                ++adjacentMines;
            }
        }
        return adjacentMines;
    }
}

