/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class SplashScreen
extends JWindow {
    private int duration;

    public SplashScreen(int d) {
        this.duration = d;
    }

    public void showSplash() {
        JPanel content = (JPanel)this.getContentPane();
        content.setBackground(new Color(255, 255, 255, 255));
        int width = 350;
        int height = 150;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        URL imgURL = Minesweeper.class.getResource("Mine.png");
        JLabel imglabel = new JLabel(new ImageIcon(imgURL));
        JLabel label = new JLabel("Loading JavaMinesweeper! . . .", 0);
        label.setFont(new Font("Sans-Serif", 1, 18));
        content.add((Component)imglabel, "Center");
        content.add((Component)label, "South");
        Color oraRed = new Color(80, 80, 80, 255);
        content.setBorder(BorderFactory.createLineBorder(oraRed, 10));
        this.setVisible(true);
    }

    public void showSplashAndExit() {
        this.showSplash();
        try {
            Thread.sleep(this.duration);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroySplash();
        System.exit(0);
    }

    public void destroySplash() {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        SplashScreen splash = new SplashScreen(2000);
        splash.setAlwaysOnTop(true);
        splash.showSplashAndExit();
    }
}

